function cdtAGz = ctauA(model,t,dt,c,basis,z,Bz,FzGz_mu, zGz)
% funcation CTAUA
%
% compute the action of the generator A on the basis functions
% at the specified sampling points, multiplied by constant c and time step
% dt
% 
% input
%     model       struct containing the model specific parameters
%     t           time
%     dt          time step
%     c           scalar
%     basis       struct containing the parameters of the basis functions
%     z           matrix containing the points at which c*dt*A*basis should 
%                 be computed
%     Bz          matrix
%     FzGz_mu     matrix
%     zGz         matrix
%     
% output 
%     cdtAGz      matrix: #sampling points x #Gaussian ansatz functions
%
% written by
%   Andrea Y. Weisse
%   Centre for Systems Biology at Edinburgh
%   University of Edinburgh
%
%   email: andrea.weisse@ed.ac.uk
%
% Copyright (C) 2011, University of Edinburgh
%
% FOR ACADEMIC USE this program is free software; you can redistribute 
% it and/or modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version. 
% See http://www.gnu.org/licenses/gpl.html for details.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details. 
% 

no = size(z,2);
n  = basis.no;
mu = basis.mu;
G  = basis.G;
a  = basis.a;

Fz       = feval(model.F,t,z,model.par);
divFz    = ones(n,1) * feval(model.traceDF,t,z,model.par);
onesVec  = ones(1,size(z,2));

switch basis.function
    case 'gaussian'
        cdtAGz = c*dt*(-divFz+FzGz_mu).*Bz;
    case 'laguerre4'
        exp_Gz_mu = zeros(basis.no);
        for m = 1:basis.no
            exp_Gz_mu(m,:)  = exp(-sum((chol(G) * abs(mu-mu(:,m)*ones(1,n))).^2, 1) + basis.a);
        end
        cdtAGz = c*dt*((-divFz+2*FzGz_mu).*Bz + 2*FzGz_mu .* exp_Gz_mu);
    case 'laguerre6'
        cdtAGz = c*dt*(-divFz.*Bz - FzGz_mu .* exp(-zGz + a) .*...
                                (-(6+model.dim*5/2+model.dim^2/4) + (6+model.dim) * zGz - zGz.^2 ) );
end

cdtAGz = cdtAGz';