%%% Version: August 28th, 2017
%%%
%%% call by: [legendStates] = Wajima_bloodCoagulation_legendLabel(States)
%%%
%%% This function assigns the right labels to the given Species to 
%%% facilitate plotting.
%%%
%%% 
%%% Author: Jane Knoechel 
%%%
function LegendStates=Wajima_bloodCoagulation_legendLabel(States)
S=struct('XII','XII','XIIa','XIIa','VIII','VIII', 'VIIIa','VIIIa','IX','IX','IXa','IXa',   ...
    'XI', 'XI','XIa','XIa','VII','VII','VIIa','VIIa','X','X','Xa','Xa', ...
    'V',  'V', 'Va','Va','Xa_Va','Xa:Va','II','II','IIa','IIa','TAT','TAT', ...
    'Fg','Fg','F','F','XF','XF','FDP','FDP','D','D','XIII','XIII', ...
    'XIIIa','XIIIa','Pg','Pg','P','P','PC','PC','APC','APC','Tmod','Tmod', ...
    'IIa_Tmod','IIa:Tmod','IXa_VIIIa','IXa:VIIIa','TF','TF','VII_TF','VII:TF',...
    'VIIa_TF','VIIa:TF','TFPI','TFPI', ...
    'Xa_TFPI','Xa:TFPI','VIIa_TF_Xa_TFPI','VIIa:TF:Xa:TFPI','PS','PS'...
    ,'APC_PS','APC:PS','Pk','Pk','K','K', ...
    'VK','VK','VKH2','VKH2','VKO','VKO','VK_p','VK\_p','Awarf','Awarf','Cwarf','Cwarf', ...
    'CA','CA','AEnox','AEnox','AT_III_Heparin','AT:III:Heparin','ENO_p','Eno\_p','AUC','AUC',...
    'AVenom','AVenom','CVenom','CVenom','TaipanVenom','TaipanVenom',...
    'ATIII','ATIII','delayTaipan1','delayTaipan1','delayTaipan2','delayTaipan2',...
    'AVenom_Tiger','AVenom\_Tiger','CVenom_Tiger','CVenom\_Tiger','AT_III_UFH','AT:III:UFH');

for i=1:length(States)
    LegendStates{i}=S.(States{i});
end
end