%%% Experimental data
%%% 
%%% Species: mouse, 25g, knock-out
%%% Drug:    mAb7E3
%%% Study:   8 mg/kg BW, i.v. bolus dosing
%%% Units:   time in [day], concentration in [nmol/L]
%%% Source:  digitized graphics from Garg, PhD thesis (2007)

function expdata = ExperimentalData_mouse_ko_mAb7E3_Garg2007

%%% -----------------------------------------------------------------------
%%% Species 
%%%

expdata.species.type   = 'mouse';
expdata.species.strain = 'knock-out';
expdata.species.BW     = 0.025;   % in [kg]

%%% -----------------------------------------------------------------------
%%% Drug
%%%
expdata.drug.name     = 'mAb7E3';
expdata.drug.class    = 'mAb';
expdata.drug.subclass = 'IgG1';
expdata.drug.MW       = 150000; % in[g/mol]

%%% -----------------------------------------------------------------------
%%% Study design
%%%
dosing.bolus.dose       = 8;   
dosing.bolus.per        = 'BW'; 

dosing.infusion.dose    = 0;  
dosing.infusion.per     = 'fixed'; 
dosing.infusion.tend    = 60; 

dosing.po.dose          = 0; 
dosing.po.per           = 'fixed';  

expdata.study.dosing            = dosing;
expdata.study.observationTime   = [0 60*24*60]; 
expdata.study.numberOfDosing    = 1;           

%%% -----------------------------------------------------------------------
%%% units and scaling factors
%%%
expdata.unit.t = 'day';
expdata.unit.C = 'nM';

expdata.SF.original_to_min = 24*60;           % scaling factor [day] -> [min]
expdata.SF.original_to_mg_per_L = 1e-9*expdata.drug.MW*1e3;  % scaling factor [nM] -> [mg/L]

%%% -----------------------------------------------------------------------
%%% Experimental data (routhly 2h, 12h, 24h, 1w, 2w 3w, 4w, 8w)
%%%
expdata.t.pla   = [8.58E-02 4.29E-01 9.44E-01 1.97E+00 3.00E+00 4.03E+00];
expdata.C.pla   = [7.71E+02; 4.28E+02; 2.38E+02; 8.65E+01; 3.33E+01; 1.67E+01];
expdata.color.pla       = 'r--.';
expdata.limits.t.pla    = [0 60];

expdata.t.lun   = [5.13E-01 1.01E+00 2.01E+00 3.01E+00 4.00E+00]';
expdata.C.lun   = [6.24E+01; 4.06E+01; 1.20E+01; 4.46E+00; 1.75E+00];
expdata.color.lun       = 'k--.';
expdata.limits.t.lun    = [0 10];

expdata.t.hea   = [2.64E-01 5.13E-01 1.00E+00 2.00E+00 3.00E+00 3.99E+00]';
expdata.C.hea   = [7.41E+01; 5.42E+01; 3.25E+01; 7.79E+00; 3.29E+00; 1.20E+00];

expdata.color.hea       = 'k--.';
expdata.limits.t.hea    = [0 10];

expdata.t.kid   = [2.79E-01 5.13E-01 1.01E+00 2.01E+00 3.01E+00 4.00E+00]';
expdata.C.kid   = [9.71E+01; 7.00E+01; 3.28E+01; 1.23E+01; 5.69E+00; 3.64E+00];
expdata.color.kid       = 'k--.';
expdata.limits.t.kid    = [0 10];

expdata.t.mus   = [4.40E-02 8.80E-02 9.98E-01 2.01E+00 3.01E+00 4.00E+00]';
expdata.C.mus   = [3.33E+01; 1.71E+01; 8.00E+00; 3.00E+00; 1.13E+00; 4.29E-01];
expdata.color.mus       = 'b--.';
expdata.limits.t.mus    = [0 10];

expdata.t.ski   = [7.33E-02 1.01E+00 2.01E+00 3.00E+00 4.00E+00]';
expdata.C.ski   = [3.21E+01; 1.26E+01; 7.90E+00; 3.28E+00; 1.34E+00];
expdata.color.ski       = 'b--.';
expdata.limits.t.ski    = [0 10];

expdata.t.gut   = [7.33E-02 4.84E-01 9.83E-01 1.98E+00 2.99E+00 3.98E+00]';
expdata.C.gut   = [3.86E+01; 2.71E+01; 1.43E+01; 3.59E+00; 1.54E+00; 5.36E-01];
expdata.color.gut       = 'k--.';
expdata.limits.t.gut    = [0 10];

expdata.t.spl   = [7.00E-02 5.23E-01 1.02E+00 2.01E+00 3.01E+00 4.00E+00]';
expdata.C.spl   = [1.29E+02; 5.45E+01; 4.05E+01; 1.18E+01; 4.06E+00; 1.55E+00];
expdata.color.spl       = 'k--.';
expdata.limits.t.spl    = [0 10];

expdata.t.liv   = [2.49E-01 4.99E-01 9.98E-01 2.00E+00 2.99E+00 3.99E+00];
expdata.C.liv   = [9.83E+01; 4.82E+01; 3.32E+01; 1.19E+01; 4.46E+00; 1.65E+00];
expdata.color.liv       = 'k--.';
expdata.limits.t.liv    = [0 10];

end
