%%% 
%%% This function simulates the models of all individuals that comprise the
%%% virtual population
%%% 
%%% Version: February 10th, 2014. 
%%% For references and citation, please see MAIN script.
%%% 
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the 
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported 
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%
%%%


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


function individual = GenericPBPKmodel_simulatePBPKmodels(individual)

%%% ======================================================================
%%% report about simulation progress
%%%
fprintf('\n   (c) Simulating PBPK model(s) ...\n');


for id=1:length(individual)
    
    %%% report about characteristics of the individual
    GenericPBPK_model_reportOnIndividual(individual(id));
    
    %%% simulate individual according to its model
    
    individual(id) = eval(sprintf('GenericPBPKmodel_%s(individual(id))',individual(id).model.type));
    
   
end;

fprintf('\n\n')

end % of function sim = GenericPBPKmodel_simulatePBPKmodel


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% END: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: LOCAL SUB-ROUTINES

%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function [] = GenericPBPK_model_reportOnIndividual(individual)
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    if strcmp(individual.type,'human')
        if individual.id<10
            fprintf('\n   individual(%1.0f):   %s; %1.2fm; %3.1fkg; ''%s''; %s;\n',...
                individual.id,char(individual.subtype),individual.BH,individual.BW,char(individual.color),individual.model.type);
        else
            fprintf('\n   individual(%2.0f):  %s; %1.2fm; %3.1fkg; ''%s''; %s;\n',...
                individual.id,char(individual.subtype),individual.BH,individual.BW,char(individual.color),individual.model.type);
        end;
    else
        if individual.id<10
            fprintf('\n   individual(%1.0f):   %s; %3.fg; ''%s''; %s;\n',...
                individual.id,char(individual.subtype),individual.BW*1000,char(individual.color),individual.model.type);
        else
            fprintf('\n   individual(%2.0f):  %s; %3.fg; ''%s''; %s;\n',...
                individual.id,char(individual.subtype),individual.BW*1000,char(individual.color),individual.model.type);
        end;
        
    end;

    %%% --- report on tissues that are lumped together
    if isfield(individual.model,'lumping')

        lumping = individual.model.lumping;
        noLumpedTis = length(lumping);
        fprintf('                    %d-CMTs: ',noLumpedTis);
        for k=1:noLumpedTis
            fprintf('{');
            for m=1:length(lumping{k})
                fprintf('%s,',char(individual.T.name(lumping{k}(m))));
            end;
            fprintf('\b},');
        end;
        fprintf('\b');
        
    fprintf('\n')
    end;
    
    

end


%%% END: LOCAL SUB-ROUTINES
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

