%%% Version: October 31st, 2014
%%% 
%%% This function describes the characteristics of the reference individuals
%%% 
%%% For references and citation, please see MAIN script.
%%% 
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the 
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported 
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

function reference = GenericPBPKmodel_referenceIndividual()

%%% -----------------------------------------------------------------------
%%% characteristics of human reference individuals
%%%

%%% male human
reference.human.male   = struct('type','human', 'sex',  'male', 'age',[], 'BW',[], 'BH',[], 'source','ICRP report');

reference.human.male_35y_73kg_176cm     = reference.human.male;
reference.human.male_35y_73kg_176cm.age = 35;
reference.human.male_35y_73kg_176cm.BW  = 73;
reference.human.male_35y_73kg_176cm.BH  = 1.76;

reference.human.male_15y_54kg_167cm     = reference.human.male;
reference.human.male_15y_54kg_167cm.age = 15;
reference.human.male_15y_54kg_167cm.BW  = 56;
reference.human.male_15y_54kg_167cm.BH  = 1.67;

reference.human.male_10y_32kg_138cm     = reference.human.male;
reference.human.male_10y_32kg_138cm.age = 10;
reference.human.male_10y_32kg_138cm.BW  = 32;
reference.human.male_10y_32kg_138cm.BH  = 1.38;

reference.human.male_5y_19kg_109cm      = reference.human.male;
reference.human.male_5y_19kg_109cm.age  = 5;
reference.human.male_5y_19kg_109cm.BW   = 19;
reference.human.male_5y_19kg_109cm.BH   = 1.09;


%%% female human
reference.human.female = struct('type','human', 'sex',  'female', 'age',[], 'BW',[], 'BH',[], 'source','ICRP report');

reference.human.female_35y_60kg_163cm     = reference.human.female;
reference.human.female_35y_60kg_163cm.age = 35;
reference.human.female_35y_60kg_163cm.BW  = 60;
reference.human.female_35y_60kg_163cm.BH  = 1.63;

reference.human.female_15y_53kg_161cm     = reference.human.female;
reference.human.female_15y_53kg_161cm.age = 15;
reference.human.female_15y_53kg_161cm.BW  = 53;
reference.human.female_15y_53kg_161cm.BH  = 1.61;

reference.human.female_10y_32kg_138cm     = reference.human.female;
reference.human.female_10y_32kg_138cm.age = 10;
reference.human.female_10y_32kg_138cm.BW  = 32;
reference.human.female_10y_32kg_138cm.BH  = 1.38;

reference.human.female_5y_19kg_109cm      = reference.human.female;
reference.human.female_5y_19kg_109cm.age  = 5;
reference.human.female_5y_19kg_109cm.BW   = 19;
reference.human.female_5y_19kg_109cm.BH   = 1.09;



%%% -----------------------------------------------------------------------
%%% characteristics of rat reference individuals
%%%

reference.rat.male = struct('type','rat', 'sex','male', 'BW',[], 'source', 'Brown et al (1997)');

reference.rat.male_250g    = reference.rat.male;
reference.rat.male_250g.BW = 0.250;

reference.rat.male_475g    = reference.rat.male;
reference.rat.male_475g.BW = 0.475;


%%% -----------------------------------------------------------------------
%%% characteristics of mouse reference individuals
%%%

reference.mouse.male = struct('type','mouse', 'sex','male', 'BW',[], 'source', []);

reference.mouse.male_25g        = reference.mouse.male;
reference.mouse.male_25g.BW     = 0.025; 
reference.mouse.male_25g.source = 'Brown et al (1997)'; 

reference.mouse.male_40g        = reference.mouse.male;
reference.mouse.male_40g.BW     = 0.040; 
reference.mouse.male_40g.source = 'Brown et al (1997)'; 

reference.mouse.male_22g_Bax        = reference.mouse.male;
reference.mouse.male_22g_Bax.BW     = 0.022; 
reference.mouse.male_22g_Bax.source = 'Baxter et al (1994)'; 

reference.mouse.male_25g_Fro        = reference.mouse.male;
reference.mouse.male_25g_Fro.BW     = 0.025; 
reference.mouse.male_25g_Fro.source = 'Fronton et al (2014)'; 


end
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% END: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: LOCAL SUB-ROUTINES




%%% END: LOCAL SUB-ROUTINES
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



