%%% Version: July 19th, 2014
%%%
%%%
%%% Experimental data
%%%
%%% Species: mouse,SCID mice bearing LS174T xenografts(C.B-17/ IcrHsd-PrkdcSCID), 4-5 weeks of age,
%%%          19 g body weight,LS174T cells exhibit high-level expression of CEA,

%%% Drug:    mAb8C2, non-binding control murine monoclonal IgG1

%%% Study:   25 mg/kg BW,single i.v. bolus dosing, definite tracer amount of 125I-labeled 8C2

%%% Units:   time in [day], concentration in [nmol/L]

%%% Source:  digitized graphics from Abuqayyas, PhD thesis (2012)



function expdata = ExperimentalData_mouse_wt_mAb8C2_Abuq2012_Dose25mgkg


%%% -----------------------------------------------------------------------
%%% Species
%%%

expdata.species.type   = 'mouse'; %SCID mouse, xenograft tumorcelltype LS174T
expdata.species.BW     = 0.019;   % in [kg] SCID mice strain C.B-17/IcrHsd-Prkdc, male,4-5 weeks of age 19.0525g BW



%%% -----------------------------------------------------------------------
%%% dosing information
%%%

dosing.drug      = 'mAb8C2';
dosing.route     = 'iv_bolus';
dosing.dose      = 25;
dosing.doseUnit  = 'mg/kg BW';
dosing.time      = 0;
dosing.timeUnit  = 'd';
dosing.repeats   = 1;
dosing.Tinf      = NaN;           % duration of iv infusion
dosing.interval  = NaN;           % multiple dosing interval

expdata.dosing   = dosing;


%%% -----------------------------------------------------------------------
%%% time information
%%%

pred.timeSpan = [0 60*24*60];
pred.timeUnit = 'd';

expdata.pred  = pred;


%%% -----------------------------------------------------------------------
%%% units and scaling factors
%%%
expdata.unit.t = 'day';
expdata.unit.C = 'nM';

expdata.SF.time_to_min = 24*60;    % scaling factor [day] -> [min]
expdata.SF.conc_to_nM  = 1;        % scaling factor [nM] -> [nM]


%%% -----------------------------------------------------------------------
%%% Experimental data
%%%

%%% FIG.8: mAb8C2- tumorLS174T
[A,b]=xlsread('abuq_8C2_LS174T_Dose25mgkg.xlsx');   %dose 25 mg/kg
errorbar.available = {};
index.pla       =find(~isnan(A(:,ismember(b,'t.pla'))));
expdata.t.pla   = [A(index.pla,ismember(b,'t.pla'))'];
expdata.C.pla   = [A(index.pla,ismember(b,'C.pla'))'];
expdata.color.pla       = 'r--.';
expdata.limits.t.pla    = [0 10];

index.tum       =find(~isnan(A(:,ismember(b,'t.tum'))));
expdata.t.tum   = [A(index.tum,ismember(b,'t.tum'))'];
expdata.C.tum   = [A(index.tum,ismember(b,'C.tum'))'];
expdata.color.tum       = 'r--.';
expdata.limits.t.tum    = [0 10];

index.lun       = find(~isnan(A(:,ismember(b,'t.lun'))));
expdata.t.lun   = [A(index.lun,ismember(b,'t.lun'))'];
expdata.C.lun   = [A(index.lun,ismember(b,'C.lun'))'];
expdata.color.lun       = 'r--.';
expdata.limits.t.lun    = [0 10];

index.gut       =find(~isnan(A(:,ismember(b,'t.gut'))));
expdata.t.gut   = [A(index.gut,ismember(b,'t.gut'))'];
expdata.C.gut   = [A(index.gut,ismember(b,'C.gut'))'];
expdata.color.gut       = 'r--.';
expdata.limits.t.gut   = [0 10];

index.liv       =find(~isnan(A(:,ismember(b,'t.liv'))));
expdata.t.liv   = [A(index.liv,ismember(b,'t.liv'))'];
expdata.C.liv   = [A(index.liv,ismember(b,'C.liv'))'];
expdata.color.liv       = 'r--.';
expdata.limits.t.liv    = [0 10];

index.spl       =find(~isnan(A(:,ismember(b,'t.spl'))));
expdata.t.spl   = [A(index.spl,ismember(b,'t.spl'))'];
expdata.C.spl   = [A(index.spl,ismember(b,'C.spl'))'];
expdata.color.spl       = 'r--.';
expdata.limits.t.spl    = [0 10];

index.hea       =find(~isnan(A(:,ismember(b,'t.hea'))));
expdata.t.hea   = [A(index.hea,ismember(b,'t.hea'))'];
expdata.C.hea   = [A(index.hea,ismember(b,'C.hea'))'];
expdata.color.hea       = 'r--.';
expdata.limits.t.hea    = [0 10];

index.kid       =find(~isnan(A(:,ismember(b,'t.kid'))));
expdata.t.kid   = [A(index.kid,ismember(b,'t.kid'))'];
expdata.C.kid   = [A(index.kid,ismember(b,'C.kid'))'];
expdata.color.kid       = 'r--.';
expdata.limits.t.kid    = [0 10];

index.ski       =find(~isnan(A(:,ismember(b,'t.ski'))));
expdata.t.ski   = [A(index.ski,ismember(b,'t.ski'))'];
expdata.C.ski   = [A(index.ski,ismember(b,'C.ski'))'];
expdata.color.ski       = 'r--.';
expdata.limits.t.ski    = [0 10];


index.mus       =find(~isnan(A(:,ismember(b,'t.mus'))));
expdata.t.mus   = [A(index.mus,ismember(b,'t.mus'))'];
expdata.C.mus   = [A(index.mus,ismember(b,'C.mus'))'];
expdata.color.mus      = 'r--.';
expdata.limits.t.mus    = [0 10];

expdata.errorbar = errorbar;
end
