%%% Version: October 31st, 2014
%%%
%%% This function specifies indexing of tissues used throughout all scripts
%%% and functions.
%%%
%%% For references and citation, please see MAIN script.
%%%
%%% Copyright (C) 2014, Universitaet Potsdam, Germany
%%% Contact: W. Huisinga, huisinga@uni-potsdam.de
%%%
%%% The program is distributed under the terms of the
%%% Creative Commons License (CC BY-NC-SA 3.0):
%%% Attribution-NonCommercial-ShareAlike 3.0 Unported
%%%
%%% For a SHORT HUMAN-READABLE SUMMARY OF THE LEGAL CODE, see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/
%%%
%%% For the Legal Code (the full license) see URL
%%% http://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
%%%


%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

function T = GenericPBPKmodel_tissueIndexing

%%% set tissue indexes and define default colors
%%%
%%% lung
T.lun =  1; T.name{T.lun} = 'lun'; T.style.lun = 'g--';

%%% artery
T.art =  2; T.name{T.art} = 'art'; T.style.art = 'g-';

%%% brain
T.bra =  3; T.name{T.bra} = 'bra'; T.style.bra = 'm:';

%%% adipose
T.adi =  4; T.name{T.adi} = 'adi'; T.style.adi = 'r--';

%%% heart
T.hea =  5; T.name{T.hea} = 'hea'; T.style.hea = 'm--';

%%% kidneys
T.kid =  6; T.name{T.kid} = 'kid'; T.style.kid = 'm-';

%%% muscle
T.mus =  7; T.name{T.mus} = 'mus'; T.style.mus = 'b--';

%%% bone
T.bon =  8; T.name{T.bon} = 'bon'; T.style.bon = 'b-';

%%% skin
T.ski =  9; T.name{T.ski} = 'ski'; T.style.ski = 'r-';

%%% gut
T.gut = 10; T.name{T.gut} = 'gut'; T.style.gut = 'k--';

%%% spleen
T.spl = 11; T.name{T.spl} = 'spl'; T.style.spl = 'k:';

%%% liver
T.liv = 12; T.name{T.liv} = 'liv'; T.style.liv = 'k-';

%%% vene
T.ven = 13; T.name{T.ven} = 'ven'; T.style.ven = 'g-';

%%% rest of body
T.rob = 14; T.name{T.rob} = 'rob'; T.style.rob = 'y-';

%%% blood
T.blo = 15; T.name{T.blo} = 'blo'; T.style.blo = 'g-';

%%% plasma
T.pla = 16; T.name{T.pla} = 'pla'; T.style.pla = 'g-';

%%% erythrocytes
T.ery = 17; T.name{T.ery} = 'ery'; T.style.ery = 'g:';

%%% tumor
T.tum = 18; T.name{T.tum} = 'tum'; T.style.tum = 'b:';


%%% tissue database (DB)
%%%
T.tissueDB = [T.lun T.art T.bra T.adi T.hea T.kid T.mus T.bon T.ski T.gut T.spl T.liv T.ven T.rob T.blo T.pla T.ery T.tum];
T.initialize.tissueDB.NaN = NaN*ones(1,max(T.tissueDB));


end
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% END: MAIN FUNCTION
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%%% BEGIN: LOCAL SUB-ROUTINES


%%% END: LOCAL SUB-ROUTINES
%%% +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++



