%%% Version: October 31st, 2015
%%%
%%%
%%% This script compares the fraction unbound over IgG/FcRn generated from KD model and Cutoff Model.
%%%


clear all
clc
close all

%%%Cutoff Model
figure1= figure(1);

axes2 = axes('Parent',figure1,...
    'FontSize',18,'XGrid','off','YGrid','off');

xlim([1e-3 1000]);ylim([-0.03 1]); hold('all');

x = [1.001:0.001:1000]; %IgG/FcRn
fu= 1-1./x;

x =[1e-3,x];
fu=[0,fu];

semilogx(x,fu,'LineWidth',2, 'Parent', axes2);
xlabel('total IgG/FcRn');ylabel('fraction not bound to FcRn');

hold on

%%%KD Model
KD      = 4.8;
FcRn    = 1e5;
x       = [1e-3:0.01:0.5, 0.5001:0.001:1000];
FcRn_eff= (1-x-(4.8/1e5))*1e5;
FcRn_u  = 1/2* (FcRn_eff + sqrt((FcRn_eff).^2 +4*KD*FcRn));
fu      = KD./(KD+FcRn_u);

semilogx(x,fu,'r--','Parent', axes2);

xlim([1e-3 1000]);ylim([-0.03 1]);
xlabel('total IgG/FcRn');ylabel('IgG fraction unbound');

legend('Cutoff model', 'KD model','Location','northwest');
set(gca,'xscale','log')
ax = gca;
set(ax,'XTick',[ 1e-3 0.01 0.1 1 10 100 1000])
set(ax,'XTickLabel',{'1e-3','1e-2','1e-1','1e0','1e1','1e2', '1e3'})

lw = 2;   %line width
fs = 18;  %fontsize

h = findobj(gca,'Type','line');
set(h,'LineWidth',lw);
set(gca,'FontSize',fs);
set(gca,'LineWidth',lw);
set(get(gca,'title'),'Fontsize',22);
set(get(gca,'xlabel'),'Fontsize',22);
set(get(gca,'ylabel'),'Fontsize',22);
set(legend,'Fontsize',22);

box('on');
axes4 = axes('Parent',figure1,'Position',[0.7 0.21 0.2 0.2],...
    'LineWidth',2,'FontSize',14,'XGrid','off','YGrid','off');
hold('all')

%%%Zoomed graphics
%%%
%%%Cutoff Model
x = [1:0.001:10]; %IgG/FcRn
fu= 1-1./x;

x =[0,x];
fu=[0,fu];

plot(x,fu,'LineWidth',2,'Parent',axes4);
xlim([0 0.8]);ylim([-0.01 5e-4 ]);
axis square
box('on');

hold on

%%%KD Model
KD      = 4.8;
FcRn    = 1e5;
x       = [0:0.01:0.5, 0.5001:0.001:10];
FcRn_eff= (1-x-(4.8/1e5))*1e5;
FcRn_u  = 1/2* (FcRn_eff + sqrt((FcRn_eff).^2 +4*KD*FcRn));
fu      = KD./(KD+FcRn_u);

plot(x,fu,'r--','LineWidth',2,'Parent',axes4);
xlim([0.15 1.1]);ylim([-0.0001 10e-4]);
axis square
box('on');



