%%% Version: October 31st, 2014

%%% data added June 12th, 2015
%%%
%%% UPDATE
%%% (1) expData now in units [min] and [nM]; dosing updated to new version
%%%
%%% Experimental data
%%%
%%% Species: mouse,  22.15g body weight, female nu/nu mice bearing T380 human
%%%          colon cancer xenograft

%%% Drug:    mAb  MOPC21, nonspecific mouse IgG1

%%% Study:   measurements of  111-In-labeled MOPC21,  0.0038 mg, i.v. bolus dosing

%%% Units:   time in [day], concentration in [nmol/L],  digitized as
%%%          time in [h] and concentration in [% injected dose/g tissue)

%%% Source:  digitized graphics from Baxter, Cancer Research 1994

function expdata = ExperimentalData_mouse_nude_mAbMOPC21_Baxter1994


%%% -----------------------------------------------------------------------
%%% Species
%%%

expdata.species.type   = 'mouse';
expdata.species.BW     = 0.022;   % in [kg]



%%% -----------------------------------------------------------------------
%%% dosing information
%%%

dosing.drug      = 'mAbMOPC21';
dosing.route     = 'iv_bolus';
dosing.dose      = 0.0038;
dosing.doseUnit  = 'mg';
dosing.time      = 0;
dosing.timeUnit  = 'd';
dosing.repeats   = 1;
dosing.Tinf      = NaN;           % duration of iv infusion
dosing.interval  = NaN;           % multiple dosing interval

expdata.dosing   = dosing;


%%% -----------------------------------------------------------------------
%%% time information
%%%

pred.timeSpan = [0 60*24*60];
pred.timeUnit = 'd';

expdata.pred  = pred;


%%% -----------------------------------------------------------------------
%%% units and scaling factors
%%%
expdata.unit.t = 'h';
expdata.unit.C = 'nM';

MW=150*1e3;
expdata.SF.time_to_min = 60;            % scaling factor [h] -> [min]
expdata.SF.conc_to_nM  = 1;             % scaling factor [nM] -> [nM] assuming density =1 g/ml


%%% -----------------------------------------------------------------------
%%% Experimental data
%%%
%%%

errorbar.available = {};

expdata.t.pla          = [4                     24                  48                      72                   96                     120];
expdata.C.pla.Baxter   = [35.496527824418045   24.149026509533886    21.239170264500654      23.536788883656367  12.708351525416942     17.294906386362168];
expdata.C.pla          =((expdata.C.pla.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.pla      = 'r--.';
expdata.limits.t.pla   = [0 130];

errorbar.available    = union('pla',errorbar.available);
errorbar.up.C.pla.Baxter  = [4.3827                2.9426               2.5767                 2.5207               1.8858                 4.7487];
errorbar.down.C.pla.Baxter= [5.4626                 2.1054              2.3541                 3.1334               1.8383                 4.7919];
errorbar.up.C.pla= ((errorbar.up.C.pla.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.pla= ((errorbar.down.C.pla.Baxter./100).*dosing.dose).*1e9/MW;


expdata.t.kid          = [4                     24                  48                      72                   96                     120];
expdata.C.kid.Baxter   = [ 7.971042992033406    5.823063353505658   5.3366992312063095      5.153724655961635    3.217923812785399     3.967206880365458 ];
expdata.C.kid          =((expdata.C.kid.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.kid      = 'r--.';
expdata.limits.t.kid   = [0 130];

errorbar.available    = union('kid',errorbar.available);
errorbar.up.C.kid.Baxter  = [2.0046           0.5251            0.791               0.7639               0.7429                 1.3331];
errorbar.down.C.kid.Baxter= [1.4887           0.5728            0.7678              0.7416               0.6478                 1.1859] ;
errorbar.up.C.kid= ((errorbar.up.C.kid.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.kid= ((errorbar.down.C.kid.Baxter./100).*dosing.dose).*1e9/MW;



expdata.t.bon          = [4                     24                   48                      72                   96                     120];
expdata.C.bon.Baxter   = [1.4308629062722733     1.3674225722843072  1.445100572016276       1.5270044907680553   0.829830175700717      1.2028583062162763];
expdata.C.bon          =((expdata.C.bon.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.bon      = 'r--.';
expdata.limits.t.bon   = [0 130];

errorbar.available    = union('bon',errorbar.available);
errorbar.up.C.bon.Baxter  = [0.3159             0.1945          0.2332              0.3371                  0.1024      0.2414];
errorbar.down.C.bon.Baxter= [0.2971             0.1703          0.2415              0.3171                  0.1153      0.2498] ;
errorbar.up.C.bon= ((errorbar.up.C.bon.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.bon= ((errorbar.down.C.bon.Baxter./100).*dosing.dose).*1e9/MW;


expdata.t.liv          = [4                     24                   48                      72                   96                     120];
expdata.C.liv.Baxter   = [ 7.2226347352333775    5.216645251859967    4.2700679161676645     4.719685320018235    2.8610255691043807     3.3245979322709434];
expdata.C.liv          =((expdata.C.liv.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.liv      = 'r--.';
expdata.limits.t.liv   = [0 130];

errorbar.available    = union('liv',errorbar.available);
errorbar.up.C.liv.Baxter  = [2.2891             0.5493             1.2143                   1.1924                  1.1002                      3.21];
errorbar.down.C.liv.Baxter= [2.3833             0.6136              1.0276                  1.045                   1.1696                      3.0845] ;
errorbar.up.C.liv= ((errorbar.up.C.liv.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.liv= ((errorbar.down.C.liv.Baxter./100).*dosing.dose).*1e9/MW;

expdata.t.lun          = [4                     24                   48                      72                   96                     120];
expdata.C.lun.Baxter   = [7.09163326739184      5.204966161801352    4.308522430013062       4.695066966348518    2.8524883580684266       3.3295693091189635];
expdata.C.lun          =((expdata.C.lun.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.lun      = 'r--.';
expdata.limits.t.lun   = [0 130];

errorbar.available    = union('lun',errorbar.available);
errorbar.up.C.lun.Baxter  = [2.2441            1.1919                0.8078                   0.9769              0.5348     1.2069  ];
errorbar.down.C.lun.Baxter= [1.9753            1.1826                0.8028                    0.8748             0.571      1.1628] ;
errorbar.up.C.lun= ((errorbar.up.C.lun.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.lun= ((errorbar.down.C.lun.Baxter./100).*dosing.dose).*1e9/MW;


expdata.t.mus          = [4                     24                   48                      72                   96                     120];
expdata.C.mus.Baxter   = [0.616123674267705      0.7554901080082761  0.7058436094868088      0.755490108008276      0.7058436094868088     0.6822575329147814];
expdata.C.mus          =((expdata.C.mus.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.mus      = 'r--.';
expdata.limits.t.mus   = [0 130];

errorbar.available    = union('mus',errorbar.available);
errorbar.up.C.mus.Baxter  = [0.2494               0.1399              0.1307                   0.0531            0.3736            0.2285];
errorbar.down.C.mus.Baxter= [0.2333               0.1071              0.1103                   0.0732            0.3717             0.2207] ;
errorbar.up.C.mus= ((errorbar.up.C.mus.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.mus= ((errorbar.down.C.mus.Baxter./100).*dosing.dose).*1e9/MW;

expdata.t.ski          = [4                     24                   48                      72                   96                     120];
expdata.C.ski.Baxter   = [2.2262984488980893    3.0426060479986585   3.185451411751053       3.305485391331554    2.2586442052899693     3.7878326499355923];
expdata.C.ski          =((expdata.C.ski.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml to [nM]
expdata.color.ski      = 'r--.';
expdata.limits.t.ski   = [0 130];

errorbar.available        = union('ski',errorbar.available);
errorbar.up.C.ski.Baxter  = [0.6041             0.4033              0.6881                   0.3721                0.4879             1.8135];
errorbar.down.C.ski.Baxter= [0.5953             0.4268              0.6121                   0.3868                0.434              1.7548] ;
errorbar.up.C.ski         = ((errorbar.up.C.ski.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.ski       = ((errorbar.down.C.ski.Baxter./100).*dosing.dose).*1e9/MW;



expdata.t.hea          = [4                     24                   48                      72                   96                     120];
expdata.C.hea.Baxter   = [4.029611320200402      2.591396301439659   2.659573702615598        2.9000535349114864    1.5549961686530684   2.217505275253933];
expdata.C.hea          =((expdata.C.hea.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.hea      = 'r--.';
expdata.limits.t.hea   = [0 130];

errorbar.available    = union('hea',errorbar.available);
errorbar.up.C.hea.Baxter  = [1.1949       0.3593                     0.4754                  0.5184              0.1702          0.5839];
errorbar.down.C.hea.Baxter= [1.1546       0.3930                     0.4421                  0.5029              0.1655           0.5937];
errorbar.up.C.hea= ((errorbar.up.C.hea.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.hea= ((errorbar.down.C.hea.Baxter./100).*dosing.dose).*1e9/MW;


expdata.t.spl          = [4                     24                   48                      72                   96                     120];
expdata.C.spl.Baxter   = [3.3855530987662523    3.5330366949927345   3.847558087367447        4.190079105786668    2.8063908011496888     5.054796821191239];
expdata.C.spl          =((expdata.C.spl.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.spl      = 'r--.';
expdata.limits.t.spl   = [0 130];

errorbar.available    = union('spl',errorbar.available);
errorbar.up.C.spl.Baxter  = [0.6296            0.5862               0.7155                0.8647               0.4936                 1.5860];
errorbar.down.C.spl.Baxter= [0.6030            0.5793               0.7388                0.8333               0.4801                 1.5518];
errorbar.up.C.spl= ((errorbar.up.C.spl.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.spl= ((errorbar.down.C.spl.Baxter./100).*dosing.dose).*1e9/MW;

expdata.t.gut          = [4                     24                   48                      72                   96                     120];
expdata.C.gut.Baxter   = [1.3493093324807865     0.7040178054762993   0.6920678887518997      0.6462624488581761   0.48307534186190915    0.7040178054762993];
expdata.C.gut          =((expdata.C.gut.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.gut      = 'r--.';
expdata.limits.t.gut   = [0 130];

errorbar.available    = union('gut',errorbar.available);
errorbar.up.C.gut.Baxter  = [0.2519            0.1173                0.1725                 0.0949              0.0615                 0.2706];
errorbar.down.C.gut.Baxter= [0.2506            0.1594                0.1835                 0.0923              0.0618                 0.2681];
errorbar.up.C.gut= ((errorbar.up.C.gut.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.gut= ((errorbar.down.C.gut.Baxter./100).*dosing.dose).*1e9/MW;


expdata.t.tum          = [4                     24                   48                      72                   96                     120];
expdata.C.tum.Baxter   = [2.761608952101845     4.875106751313176     5.561808782546165      5.31512498520532    2.985804731071837       4.365120343543713];
expdata.C.tum          =((expdata.C.tum.Baxter./100).*dosing.dose).*1e9/MW; %unit [mg/g] assuming density =1 g/ml
expdata.color.tum      = 'r--.';
expdata.limits.t.tum   = [0 130];

errorbar.available    = union('tum',errorbar.available);
errorbar.up.C.tum.Baxter  = [0.9046             0.6110               1.3171                  1.0301              0.5787                1.5688];
errorbar.down.C.tum.Baxter= [0.9132             0.5430               1.1177                  1.1673              0.5717                1.5451];
errorbar.up.C.tum= ((errorbar.up.C.tum.Baxter./100).*dosing.dose).*1e9/MW;
errorbar.down.C.tum= ((errorbar.down.C.tum.Baxter./100).*dosing.dose).*1e9/MW;



expdata.errorbar = errorbar;





end
